
Include "data.geo" ;

Group{
  Domaine = Region[{DISQUE,SOURCE}];
  Source = Region[{SOURCE}];
  Dirichlet = Region[{DIRICHLET}];
  Neumann = Region[{NEUMANN}];
}

If(typele<2)
  DefineConstant[ 
    ordre = {1, Choices {1="Linéaire", 2="Quadratique", 3="Cubique"}, 
      Name "Modèle/Paramètres/ordre", Label "Ordre d'interpolation BF"}
  ];
  Else
  DefineConstant[ 
    ordre = {1, Choices {1="Linéaire", 2="Quadratique"}, 
      Name "Modèle/Paramètres/ordre", Label "Ordre d'interpolation BF"}];
EndIf


Function{
  beta[#{Source}] = 1.0;
  gamma[#{Neumann}] = 1.0;
  normuref = 0.017936406546008/(Pi*Rd^2);
  normgraduref = 0.06644481441100346/(Pi*Rd^2);
}


Jacobian{
  { Name Jvol;
    Case {
      { Region All ; Jacobian Vol; }
    }
  }
}

Integration {
  { Name Integ;
    Case { 
      {Type Gauss;
	Case { 
	  { GeoElement Line ; NumberOfPoints 2; }
	  { GeoElement Triangle ; NumberOfPoints 6; }
	  { GeoElement Quadrangle ; NumberOfPoints 4; }
	}
      }
    }
  }
}


Constraint {	
  {Name ConditionDirichlet ;
    Case {      
      {Region Dirichlet ; Type Assign ; Value 0. ;}
    }
  }
}


FunctionSpace {
  { Name Hgrad ; Type Form0 ; 
    BasisFunction { 
      { Name sn ; NameOfCoef phi ; Function BF_Node ; 
	Support Region[{Domaine,Neumann}]  ; Entity NodesOf[All] ; }
      If (ordre > 1)
	{ Name sa2 ; NameOfCoef phi2 ; Function BF_Node_2E ; 
	  Support Region[{Domaine,Neumann}]  ; Entity EdgesOf[All] ; }
	If (ordre > 2)
	  { Name sf3 ; NameOfCoef phi3 ; Function BF_Node_3F ; 
	    Support Region[{Domaine,Neumann}]  ; Entity FacetsOf[All] ; }
	EndIf
      EndIf
    } 
    Constraint {
      { NameOfCoef phi  ; EntityType NodesOf ; NameOfConstraint ConditionDirichlet ; }
      If (ordre > 1)
	{ NameOfCoef phi2  ; EntityType EdgesOf ; NameOfConstraint ConditionDirichlet ; }
	If (ordre > 2)
	  { NameOfCoef phi3  ; EntityType FacetsOf ; NameOfConstraint ConditionDirichlet ; }
	EndIf
      EndIf
    }
  }
}


Formulation {
  { Name Poisson ; Type FemEquation ;

    Quantity {
      { Name u  ; Type Local  ; NameOfSpace Hgrad ; }
    }
    
    Equation {
  
      Galerkin { [ Dof{Grad u}  , {Grad u} ] ;
	In Domaine ; Jacobian Jvol ; Integration Integ ; }

      Galerkin { [  -beta[] , {u} ] ;
	In Source ; Jacobian Jvol ; Integration Integ ; }
      
      Galerkin { [ -gamma[] , {u} ] ; 
      	In Neumann ; Jacobian Jvol ; Integration Integ ; }
    }
  }
}


Resolution {
  { Name analyse ;
    System {
      { Name Sys ; NameOfFormulation Poisson ; }
    }
    Operation {
      Generate[Sys] ; 
      Solve[Sys] ;
      SaveSolution[Sys] ;
    }
  }
}

PostProcessing {
  { Name PostProc ; NameOfFormulation Poisson ;
    Quantity {	
      { Name u  ; Value { Term { [ {u} ] ; In Domaine ; Jacobian Jvol ; } } }
      { Name Grad_u  ; Value { Term { [ {Grad u} ] ; In Domaine ; Jacobian Jvol ; } } }
      { Name normu ; Value { Integral { [ Norm[{u}] ]  ; In Domaine ; 
	    Jacobian Jvol ; Integration Integ ;} } }
      { Name normgradu ; Value { Integral { [ Norm[{Grad u}] ]  ; In Domaine ; 
	    Jacobian Jvol ; Integration Integ ;} } }
      { Name epsnormu ; Value { Integral { [100.0*( Norm[{u}]/normuref-1) ]  ; In Domaine ; 
	    Jacobian Jvol ; Integration Integ ;} } }
      { Name epsnormgradu ; Value { Integral { [100.0*( Norm[{Grad u}]/normgraduref-1) ]  ; In Domaine ; 
	    Jacobian Jvol ; Integration Integ ;} } }
    }
  }
}


PostOperation PostOp UsingPost PostProc {
  Print[ Grad_u, OnElementsOf Domaine, File "gradu.pos"] ;
  Print[ u, OnElementsOf Domaine, File "u.pos"] ;
  Print[ normu[Domaine], OnGlobal, File "normu.dat", 
    SendToServer "Modele/Resultats/1Norme (u)", Color "AliceBlue" ];
  Print[ epsnormu[Domaine], OnGlobal, File "epsnormu.dat", 
    SendToServer "Modele/Resultats/2Ecart Norme (u) en %", Color "Red" ];
  Print[ normgradu[Domaine], OnGlobal, File "normgradu.dat", 
    SendToServer "Modele/Resultats/3Norme (grad u)", Color "AliceBlue" ];
  Print[ epsnormgradu[Domaine], OnGlobal, File "epsgradnormu.dat", 
    SendToServer "Modele/Resultats/4Ecart Norme (grad u) en %", Color "Red" ];
}
